#ifdef WIN32

#ifndef DESKTOPSHARINGCONTROLLERIMPL_H
#define DESKTOPSHARINGCONTROLLERIMPL_H

#include "csfunified/featuresets/adapters/FeatureSetAdapter.h"
#include "csfunified/framework/UnifiedFactory.h"
#include "csfunified/services/impl/base/DesktopSharingControllerBaseImpl.h"
#include "csfunified/services/interface/DSCallback.h"
#include "DSMgrDef.h"

#include "../JabberServiceProvider.h"

#include "sdkwrapper/win32/autoupgrade/jabber_sdk_wrap_impl.h"

namespace CSFUnified
{
    class DesktopSharingControllerImpl : public DesktopSharingControllerBaseImpl, public IDSMgrEvent
    {
    public:
        virtual ~DesktopSharingControllerImpl();
		static DesktopSharingControllerImpl * getInstance();

        // base impl
        void registerDSCallback(SMART_PTR_NS::shared_ptr<CSFUnified::DSCallback> dsCallback);
        void unregisterDSCallback(SMART_PTR_NS::shared_ptr<CSFUnified::DSCallback> dsCallback);
        bool isInSharing( );
        bool canStartSharing(std::string sessionName);
        bool startSharing(std::string sessionName);
        bool canJoinSharing(std::string sessionName);
        bool joinSharing(std::string sessionName);
        bool stopSharing( );
        bool reInviteCurSession();
        bool restartSharing( );
        bool changePresenter( );
        bool cancelSharing( );
        bool declineSharing(std::string sessionName);
        
        // IDSMgrEvent
        void OnStartingDialogShow(bool bShow);
        void OnNotifyUIUpdate();
        void OnSessionStarted(const wstring& strSessionName);
        void OnSessionEnded();
        void OnSessionFailed(INT eType);
        void OnSessionStopped();
        void OnRecvSessionInvitation(const wstring& strSessionName);
        void OnDeclineInvitation(const wstring& strSessionName);
        void OnRequestOpenChat();
        void OnRequestMinimizeChat();
        void OnUserJoined();
        void OnUserTryLeave(BOOL bHost);
        void OnUserLeft();
        void OnCleanSession(const wstring strSessionName);
        void OnCleanUp();
        void OnErrorMsg(const wstring& strSessionName, INT eType);
        void OnPresenterDidChange();

		std::string GetDSToken();
		void OnDSTokenValueChanged();

		void OnSenderPresenceChanged(std::string strSessionName);

        void start();
        void stop();

    private:
        DesktopSharingControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
		void AddPresenceNotifierConnection(std::string senderName);
		void DelPresenceNotifierConnection();

	private:
        SMART_PTR_NS::shared_ptr<UnifiedFactory> m_unifiedFactory;
		DSCallback* m_dsCallback;
		bool m_started;
		JabberServiceProvider* m_pJabberServiceProvider;

		PropertyNotifierConnectionWPtr m_ptrDSTokenChanged;
		PropertyNotifierConnectionWPtr m_pSenderPresenceChange;
		JM_SDK_WRAP::JabberSDKWrapImpl* m_pInstance;
		IDSMgr* m_pDSMgr;

		std::string m_strSessionName;
    };
    
}

#endif

#endif